--[[
Heavily modified for some custom garbage.
This script can read certain arbitrary tags placed into an ordinary .lrc file,
and magically[citation needed] turn it into LYRIC TIMING!
...At least, that was the plan. The truth is, cropleft/right are too unreliable,
as are the maths needed to make this work in the first place.
sigh...

The following will work:
<X=[float from 0 to 1]>
e.g. <X=0.5>text
	Make the scrolling effect take * 0.5 of the line's duration to go through the text following the tag.
	So, if a line lasted 2 seconds, this segment of text would take 1 second to scroll through.

<X=[1st float from 0 to 1]/[2nd float from 0 to 1]>
e.g. <X=0.5/0.2>text
	After scrolling through the segment of text as above,
	pause the lyric scrolling effect for the specified percentage of the tag segment time.
	This amount of time will automatically be taken out of the scrolling effect,
	so you can have (for instance) fast words with long pauses after them.

The following is broken for now:
<X=[float]s>
e.g. <X=0.5s>text
	Make the scrolling effect take 0.5 seconds to go through the text following the tag.
	This may be easier than trying to calculate line duration percentage in some cases.


Example usage:
[00:03.993]<X=0.1/0.5>Hum<X=0.1>pty <X=0.1/0.5>Du<X=0.6>mpty sat on the wall<
*Lines using these tags need an extra "<" at the end so the script'll read them without erroring out;
I don't like the fix but I'm running out of patience

Precautions:
Make sure the values of all the tags add up to 1 or less. If not, scrolling may not finish before the next line displays.

--]]

function Actor:LyricCommand(side)
	-- If any of the aforementioned tags are here, remove them from the actual lyric display.
	local rawText = Var "LyricText"
	local cleanText, xFuncCount = string.gsub(rawText, "<X(.-)>", "")
	
	self:draworder(DrawOrder.Screen+1)
	-- make this a little more unnecessarily complex than needed because of aformentioned "<" workaround
	self:settext((cleanText ~= "" and xFuncCount > 0) and cleanText:sub(1,cleanText:len()-1) or cleanText)
	-- Fix multiple lines clipping under the overlay
	if string.find(rawText, "\n") then
		self:vertalign(bottom)
	else
		self:vertalign(middle)
	end

	self:stoptweening()
	self:zoom(0.75):strokecolor(Color.Black):wrapwidthpixels((_screen.w-10)/0.75)
	--zoomx(clamp(SCREEN_WIDTH/(self:GetZoomedWidth()+1), 0, 0.75))

	local Color = Var "LyricColor"
	local Factor = 1
	if side == "Back" then
		Factor = 0.5
	elseif side == "Front" then
		Factor = 1
	end
	self:diffuse({
		Color[1] * Factor,
		Color[2] * Factor,
		Color[3] * Factor,
		Color[4] * Factor
	})

	if side == "Front" then
		self:cropright(1)
	else
		self:cropleft(0)
	end
	--self:diffusealpha(0):linear(0.1):diffusealpha(0.75)
	
	if xFuncCount > 0 then
		local cropFactor = 0
		
		local manualCount = 0
		for xFString in string.gfind(rawText, "<X(.-)>") do
			manualCount = manualCount + 1
			local xFTimeBleb = string.gsub(xFString, "=", "")
			-- Turn it into a table, whether or not it has slash to indicate a delay.
			local xFTime = string.find(xFTimeBleb, "/") and split("/", xFTimeBleb) or {xFTimeBleb}
			--SM(xFTime[1])
			
			local isSeconds = false
			--doesn't work
			-- Percentage or time? If there's an "s", it's exact seconds.
			if string.find(xFTime[1], "s") then
				xFTime[1] = string.gsub(xFTime[1], "s", "")
				isSeconds = true
			end
			
			-- Time to start "queueing".
			
			local findEnd = manualCount == xFuncCount and "" or "[<%[]"
			local sigh, whatever, killme = string.find(rawText, xFString .. ">(.-)<")
			-- Force the line to finish.
			cropFactor = manualCount == xFuncCount and 1 or clamp(cropFactor + (killme:len() / self:GetText():len()), 0, 1)
			
			--local tweenTime
			
			if isSeconds then
				-- Basing it on exact seconds.
				-- If there's a delay involved, take the percentage of time that takes out.
				self:linear(xFTime[2] and (xFTime[1] - (xFTime[1] * xFTime[2])) or xFTime[1])
			else
				-- Basing it on a "percentage" of the line duration this time rather than exact seconds.
				self:linear(xFTime[2] and Var "LyricDuration" * (xFTime[1] - (xFTime[1] * xFTime[2])) or Var "LyricDuration" * xFTime[1])
			end
			
			if side == "Front" then
				self:cropright(scale(cropFactor, 0, 1, 1, 0))
			else
				--self:cropleft(cropFactor)
			end
			
			-- Delay time is based on a fraction of the fraction of time this tween takes.
			-- (hahaha)
			if xFTime[2] then
				self:sleep(Var "LyricDuration" * (xFTime[1] * xFTime[2]) )
			end
			
			--SM(cropFactor)
		end
	else
		self:linear(Var "LyricDuration" * 0.9)
		if side == "Front" then
			self:cropright(0)
		else
			self:cropleft(1)
		end
	end
end

-- (c) 2006 Glenn Maynard
-- All rights reserved.
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a
-- copy of this software and associated documentation files (the
-- "Software"), to deal in the Software without restriction, including
-- without limitation the rights to use, copy, modify, merge, publish,
-- distribute, and/or sell copies of the Software, and to permit persons to
-- whom the Software is furnished to do so, provided that the above
-- copyright notice(s) and this permission notice appear in all copies of
-- the Software and that both the above copyright notice(s) and this
-- permission notice appear in supporting documentation.
-- 
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
-- OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
-- MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
-- THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
-- INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
-- OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
-- OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
-- OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
-- PERFORMANCE OF THIS SOFTWARE.

